% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program IndexGrayscale.m
[M,  map] = imread('Church.jpg',  'jpeg');
M1 = rgb2gray(M);
 
clut1 = [(255:-1:0)'  (255:-1:0)'  (255:-1:0)']/255;
M2 = ind2gray(M1,  clut1);
showImage(M2,   'grayscale');
 
[M3,  clut2] = gray2ind(M2,  256); 
        % gray2ind returns a grayscale image M3 with a
        % color lookup table clut2

